package MusicLandscape.util.matcher;

import MusicLandscape.entities.Track;
import MusicLandscape.util.MyStringMatcher;

public class WriterMatcher extends MyStringMatcher<Track> {
    /**
     * Creates a Matcher object with a specified pattern.
     *
     * @param pat the pattern of this matcher
     */
    public WriterMatcher(String pat) {
        super(pat);
    }

    /**
     * Matches an object against the pattern of this matcher.
     *
     * @param track the object to match
     * @return whether t matches the pattern of this matcher.
     */
    @Override
    public boolean matches(Track track) {
        return track.getWriter().getName().matches("^" + pattern + ".*");
    }

    /**
     * the string representation is <kbd>writer starts with (PATTERN)</kbd>
     *
     * @return a string representation of the object.
     */
    @Override
    public String toString() {
        return "writer starts with (" + pattern + ")";
    }
}
